/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing.treetable;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.install.commons.swing.treetable.DefaultTreeTableModel;
import oracle.install.commons.swing.treetable.JTreeTable;
import oracle.install.commons.swing.treetable.TreeTableHeaderPopup;
import oracle.install.commons.swing.treetable.TreeTableModelAdapter;

public class JTreeTableEx
extends JTreeTable
implements Serializable {
    private DefaultTreeTableModel treeTableModel;
    private DefaultMutableTreeNode root;
    protected JTree tree;
    private final PropertyChangeListener modelListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("DefaultTreeTableModel.columns")) {
                JTreeTableEx.this.configureTree();
            } else if (e.getPropertyName().equals("DefaultTreeTableModel.columnsVisibility")) {
                TreeTableModelAdapter model = (TreeTableModelAdapter)JTreeTableEx.this.getModel();
                model.fireTableStructureChanged();
            }
        }
    };
    private TreeTableHeaderPopup popup;
    private boolean columnSelectionPopupEnabled;

    public JTreeTableEx() {
        this(new DefaultTreeTableModel());
    }

    public JTreeTableEx(DefaultTreeTableModel model) {
        super(model);
        this.setTreeTableModel(model);
        this.popup = new TreeTableHeaderPopup(this);
        final JTableHeader header = this.getTableHeader();
        header.add(this.popup);
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (JTreeTableEx.this.columnSelectionPopupEnabled && e.getClickCount() == 1 && e.getButton() == 3) {
                    JTreeTableEx.this.popup.show(header, e.getX(), e.getY());
                }
            }
        });
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(39, 0, true), "JTreeTableEx.expand");
        actionMap.put("JTreeTableEx.expand", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JTree tree = JTreeTableEx.this.getTree();
                final TreePath selectionPath = tree.getSelectionPath();
                tree.expandPath(selectionPath);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tree.setSelectionPath(selectionPath);
                    }
                });
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(37, 0, true), "JTreeTableEx.collapse");
        actionMap.put("JTreeTableEx.collapse", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JTree tree = JTreeTableEx.this.getTree();
                final TreePath selectionPath = tree.getSelectionPath();
                tree.collapsePath(selectionPath);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        tree.setSelectionPath(selectionPath);
                    }
                });
            }
        });
    }

    public void setColumnSelectionPopupEnabled(boolean columnSelectionPopupEnabled) {
        this.columnSelectionPopupEnabled = columnSelectionPopupEnabled;
    }

    public boolean isColumnSelectionPopupEnabled() {
        return this.columnSelectionPopupEnabled;
    }

    private void configureTree() {
        if (this.treeTableModel.getTreeColumn() != -1) {
            this.tree = (JTree)((Object)this.getCellRenderer(0, this.treeTableModel.getTreeColumn()));
            this.tree.putClientProperty("JTree.lineStyle", "Angled");
            this.tree.setRootVisible(false);
            this.tree.setScrollsOnExpand(true);
            this.tree.getSelectionModel().setSelectionMode(1);
            TreeTableModelAdapter model = (TreeTableModelAdapter)super.getModel();
            model.fireTableStructureChanged();
            this.tree.expandRow(0);
        }
    }

    public void setTreeTableModel(DefaultTreeTableModel model) {
        if (this.treeTableModel == model) {
            return;
        }
        DefaultTreeTableModel oldModel = this.treeTableModel;
        super.setTreeTableModel(model);
        this.treeTableModel = model;
        this.configureTree();
        if (oldModel != null) {
            oldModel.removePropertyChangeListener(this.modelListener);
        }
        this.treeTableModel.addPropertyChangeListener(this.modelListener);
        this.root = (DefaultMutableTreeNode)this.treeTableModel.getRoot();
        this.firePropertyChange("JTreeTableEx.model", oldModel, model);
    }

    public DefaultTreeTableModel getTreeTableModel() {
        return this.treeTableModel;
    }

    @Override
    public JTree getTree() {
        return this.tree;
    }

    public void reload() {
        this.treeTableModel.reload();
        this.setNodeExpanded(this.getRoot(), true);
    }

    public void setSelectedNodesExpanded(boolean expand) {
        int[] row = this.getSelectedRows();
        if (row != null) {
            for (int i = 0; i < row.length; ++i) {
                TreePath treePath = this.tree.getPathForRow(row[i]);
                if (expand) {
                    this.tree.expandPath(treePath);
                    continue;
                }
                this.tree.collapsePath(treePath);
            }
        }
    }

    public boolean setNodeExpanded(DefaultMutableTreeNode node, boolean expand) {
        boolean success = false;
        TreePath path = new TreePath(node.getPath());
        if (expand) {
            success = !this.tree.isExpanded(path);
            if (success) {
                this.tree.expandPath(path);
            }
        } else {
            success = !this.tree.isCollapsed(path);
            if (success) {
                this.tree.collapsePath(path);
            }
        }
        return success;
    }

    public boolean setSubTreeExpanded(DefaultMutableTreeNode node, boolean expand) {
        Enumeration<TreeNode> e;
        boolean success = false;
        Enumeration<TreeNode> enumeration = e = expand ? node.preorderEnumeration() : node.postorderEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)e.nextElement();
            if (childNode.isRoot()) continue;
            success = this.setNodeExpanded(childNode, expand) || success;
        }
        return success;
    }

    public boolean collapseAll() {
        return this.setSubTreeExpanded((DefaultMutableTreeNode)this.treeTableModel.getRoot(), false);
    }

    public boolean expandAll() {
        return this.setSubTreeExpanded((DefaultMutableTreeNode)this.treeTableModel.getRoot(), true);
    }

    public void reload(DefaultMutableTreeNode orgNode) {
        this.treeTableModel.reload(orgNode);
    }

    public void reset() {
        this.treeTableModel.reset();
        this.tree.setRootVisible(false);
        this.treeTableModel.refreshNode(this.root);
        this.refresh();
    }

    public void setTreeRootVisible(boolean visible) {
        this.tree.setRootVisible(visible);
        this.tree.validate();
        this.refresh();
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    public DefaultMutableTreeNode[] getSelectedNodes() {
        int[] row = this.getSelectedRows();
        DefaultMutableTreeNode[] selectedNodes = null;
        if (row != null) {
            selectedNodes = new DefaultMutableTreeNode[row.length];
            for (int i = 0; i < row.length; ++i) {
                TreePath treePath = this.tree.getPathForRow(row[i]);
                selectedNodes[i] = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            }
        }
        return selectedNodes;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        int row = this.getSelectedRow();
        DefaultMutableTreeNode selectedNode = null;
        if (row != -1) {
            TreePath treePath = this.tree.getPathForRow(row);
            selectedNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        }
        return selectedNode;
    }

    public boolean isDuplicate(DefaultMutableTreeNode searchNode) {
        return this.treeTableModel.isDuplicate(searchNode);
    }

    public void setSelectedNode(DefaultMutableTreeNode node) {
        final TreePath nodePath = new TreePath(node.getPath());
        this.tree.scrollPathToVisible(nodePath);
        int row = this.tree.getRowForPath(nodePath);
        Rectangle rect = this.getCellRect(row, 0, false);
        this.scrollRectToVisible(rect);
        this.getSelectionModel().setSelectionInterval(row, row);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTreeTableEx.this.tree.setSelectionPath(nodePath);
            }
        });
    }

    public void highlightNode(DefaultMutableTreeNode node) {
        this.treeTableModel.refreshNode(node);
        this.refresh();
        this.tree.expandPath(new TreePath(node.getPath()));
        this.setSelectedNode(node);
    }

    public DefaultMutableTreeNode addNode(DefaultMutableTreeNode node) throws Exception {
        return this.addNode(this.root, node);
    }

    public DefaultMutableTreeNode addNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode node) throws Exception {
        this.treeTableModel.addNode(parent, node);
        this.refresh();
        this.highlightNode(node);
        return node;
    }

    public boolean removeNode(DefaultMutableTreeNode node) throws Exception {
        if (this.treeTableModel.removeNode(node)) {
            this.refresh();
            return true;
        }
        return false;
    }

    public boolean moveNode(DefaultMutableTreeNode newParent, DefaultMutableTreeNode node) throws Exception {
        if (this.treeTableModel.moveNode(newParent, node)) {
            this.refresh();
            this.highlightNode(node);
            return true;
        }
        return false;
    }

    public boolean isMovable(DefaultMutableTreeNode newParent, DefaultMutableTreeNode node) {
        return this.treeTableModel.isMovable(newParent, node);
    }

    public void refresh() {
        TreeTableModelAdapter model = (TreeTableModelAdapter)super.getModel();
        model.refresh();
    }

    public void refreshCell(DefaultMutableTreeNode node, int col) {
        TreePath nodePath = new TreePath(node.getPath());
        int row = this.tree.getRowForPath(nodePath);
        TreeTableModelAdapter model = (TreeTableModelAdapter)super.getModel();
        model.fireTableCellUpdated(row, col);
    }
}

